module.exports = function(grunt) {

	grunt.config('compass', {
		options: {
			sassDir: '<%= yeoman.app %>/assets/css/sass',
			cssDir: '.tmp/assets/css',
			imagesDir: '<%= yeoman.app %>/assets/images',
			javascriptsDir: '<%= yeoman.app %>/libs',
			importPath: ['<%= yeoman.app %>/libs', '<%= yeoman.app %>/src', '<%= yeoman.app %>/assets/css/sass'],
			relativeAssets: false,
			assetCacheBuster: false,
			noLineComments: true,
			debugInfo: false,
			raw: 'Sass::Script::Number.precision = 10\n'
		},
		server: {
			options: {
				debugInfo: false
			}
		}
	});

	grunt.loadNpmTasks('grunt-contrib-compass');

};
